#include "WrappingTextView.h"

WrappingTextView::WrappingTextView(BRect a_frame,const char* a_name,int32 a_resize_mode,int32 a_flags)
: BTextView(a_frame, a_name, BRect(4.0,4.0,a_frame.right-a_frame.left-4.0,a_frame.bottom-a_frame.top-4.0),
	a_resize_mode,a_flags)
{
	ResetTextRect();
	m_modified = false;
	m_modified_disabled = false;
}	


WrappingTextView::~WrappingTextView()
{ }


void WrappingTextView::DetachedFromWindow()
{
	//This is sort of what the destructor should do, but...  Derived class's destructors get called before
	//WrappingTextView's destructor so StoreChange won't get to the derived class's version of it.
	if(m_modified)
	{
		StoreChange();
		m_modified = false;
	}
}


void WrappingTextView::FrameResized(float a_width, float a_height)
{
	ResetTextRect();
	BTextView::FrameResized(a_width,a_height);
}


void WrappingTextView::MakeFocus(bool a_focused)
{
	BTextView::MakeFocus(a_focused);
	if(!a_focused && m_modified)
	{
		StoreChange();
		m_modified = false;
	}
}


void WrappingTextView::InsertText(const char *a_text, int32 a_length, int32 a_offset,
	const text_run_array *a_runs)
{
	BTextView::InsertText(a_text, a_length, a_offset, a_runs);
	if(!m_modified_disabled)
		Modified();
}


void WrappingTextView::Modified()
{
	m_modified = true;
}


void WrappingTextView::SetText(const char *text, int32 length, const text_run_array *runs)
{
	m_modified_disabled = true;
	BTextView::SetText(text,length,runs);
	m_modified_disabled = false;
}


void WrappingTextView::SetText(const char *text, const text_run_array *runs)
{
	m_modified_disabled = true;
	BTextView::SetText(text,runs);
	m_modified_disabled = false;
}


void WrappingTextView::SetText(BFile *file, int32 offset, int32 length, const text_run_array *runs)
{
	m_modified_disabled = true;
	BTextView::SetText(file,offset,length,runs);
	m_modified_disabled = false;
}


void WrappingTextView::StoreChange()
{ }


void WrappingTextView::ResetTextRect()
{
	BRect textRect = Bounds();
	textRect.left = 4.0;
	textRect.top = 4.0;
	textRect.right -= 4.0;
	textRect.bottom -= 4.0;
	SetTextRect(textRect);
}


bool WrappingTextView::HasBeenModified()
{
	return m_modified;
}
